/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_15; import java.util.Calendar;

import lotus.domino.*; import djbuch.kapitel_06.*;
/**
 * @author Thomas Ekert
 * 
 */
public class ToyStoreAdvancedDemo implements Runnable {

	private static final String PASSWORD = "geheim";
	private static final String HOST = "www.djbuch.de:63148"; 		//null fr lokale Session
	private static final String USER = "Thomas Ekert/DJBUCH";	//null fr lokale Session
	
	public static void main(String[] args) {
		ToyStoreAdvancedDemo tsAdvanced = new ToyStoreAdvancedDemo ();
		NotesThread nt = new NotesThread (tsAdvanced);
		nt.start();
	}
	
	public void run () {
		Session session = null;
		ToyStoreAdvanced ts = null;
		Document doc = null;
		DocumentCollection dc = null;
		ViewEntryCollection vec = null;
		DateTime dt = null;
		try {
			session=NotesFactory.createSession (HOST, USER, PASSWORD);
			
			/* Neuer ToyStore und Toys */
			ts = new ToyStoreAdvanced ("djbuch/djbuch.nsf", session);			
			int id1 = ts.addToy("Big dog " + DemoTools.getRandomString(5),
					"This company " + DemoTools.getRandomString(3));
			int id2 = ts.addToy("Small dog " + DemoTools.getRandomString(3),
					"Other company " + DemoTools.getRandomString(5));
			System.out.println ("Erstellt: " + ts.getToy(id1));
			doc = ts.getToyDocument(id2);
			System.out.println ("Erstellt: " + doc.getItemValueString(ToyStoreAdvanced.ITEM_NAME));
			doc.recycle();

			/* Suche mit einem Key - ein Treffer */
			doc = ts.findToyByName("sMal");
			System.out.println("\n" + doc == null ? "NULL!" : "Gefunden: "
					+ doc.getItemValueString(ToyStoreAdvanced.ITEM_NAME));
			doc.recycle();

			/* Suche mit zwei Keys - ein Treffer */
			doc = ts.findToyByName("BIG","THIS");
			System.out.println("\n" + doc == null ? "NULL!" : "Gefunden: "
					+ doc.getItemValueString(ToyStoreAdvanced.ITEM_NAME));

			/*  Suche mit einem Key  - alle Treffer */
			dc = ts.findAllToysByName("biG");
			dumpDC (dc);
			dc.recycle();
			
			/*  Suche mit einem Date Key  - alle Treffer */
			dt = session.createDateTime(Calendar.getInstance());
			dc = ts.findAllToysByDate(dt);
			dumpDC (dc);
			
			/* Volltextsuche */
			vec = ts.findAllFT("?oG and not OthEr and ([F_ID]<=15)");
			dumpVEC(vec);
		} catch (NotesException e) {
			System.out.println ("id = " + e.id);
			e.printStackTrace();
		} finally {
			GC.recycle (dt);
			GC.recycle (doc);
			GC.recycle (dc);
			GC.recycle (vec);
			if (ts!=null) {
				ts.recycle();
			}
			GC.recycle(session);
		}
	}
	
	private static void dumpDC (DocumentCollection docCollection) throws NotesException {
		Document thisDoc = null, nextDoc = null;
		int count = 1, size=0;
		try {
			size= docCollection.getCount();
			thisDoc = docCollection.getFirstDocument();
			System.out.println (thisDoc==null?"Nichts gefunden\n":"\n");
			while (thisDoc != null) {
				System.out.println("Dokument " + count++ + " / " + size
						+ ":\t" + thisDoc.getItemValueString(ToyStoreAdvanced.ITEM_NAME)
						+ " / " + thisDoc.getItemValueString(ToyStoreAdvanced.ITEM_MANUFACTURER));
				nextDoc = docCollection.getNextDocument();
				GC.recycle(thisDoc);
				thisDoc = nextDoc;
			}
		} finally {
			GC.recycle (thisDoc); GC.recycle (nextDoc);
		}
	}
	private static void dumpVEC (ViewEntryCollection veCollection) throws NotesException {
		ViewEntry thisEntry = null, nextEntry = null;
		int count = 1, size=0;
		try {
			size= veCollection.getCount();
			thisEntry = veCollection.getFirstEntry();
			System.out.println (thisEntry==null?"Nichts gefunden\n":"\n");
			while (thisEntry != null) {
				System.out.print ("Score: " + thisEntry.getFTSearchScore() + "\t");
				System.out.println("Dokument " + count++ + " / " + size
						+ ":\t" + thisEntry.getDocument().getItemValueString(ToyStoreAdvanced.ITEM_NAME)
						+ " / " + thisEntry.getDocument().getItemValueString(ToyStoreAdvanced.ITEM_MANUFACTURER)
						+ " / " + thisEntry.getDocument().getItemValueInteger(ToyStoreAdvanced.ITEM_ID));
				nextEntry = veCollection.getNextEntry();
				GC.recycle(thisEntry);
				thisEntry = nextEntry;
			}
		} finally {
			GC.recycle (thisEntry); GC.recycle (nextEntry);
		}
	}
}
